//+------------------------------------------------------------------+
//|                                                    M.A.C.H 3.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 White
#property indicator_width1 3
#property indicator_color2 DarkOrange
#property indicator_width2 3
#property indicator_maximum 1.05
#property indicator_minimum -0.05
//#property indicator_color3 Red/
//#property indicator_color4 White
//---- parameters
extern int MaMetod  = 1;
extern int MaPeriod = 40;
//---- buffers
extern int SoundAlertMode = 1;

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double trend[];
//----
int ExtCountedBars=0;
bool UpTrendAlert=false, DownTrendAlert=false;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|
int init()
  {
//---- indicators
IndicatorBuffers(5);
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1, ExtMapBuffer2);
  // SetIndexStyle(2,DRAW_HISTOGRAM, 0, 3, Red);
   SetIndexBuffer(2, ExtMapBuffer3);
  // SetIndexStyle(3,DRAW_HISTOGRAM, 0, 3, White);
   SetIndexBuffer(3, ExtMapBuffer4);
   SetIndexBuffer(4,trend);
//----
   SetIndexDrawBegin(0,10);
   SetIndexDrawBegin(1,10);
   //SetIndexDrawBegin(2,10);
   //SetIndexDrawBegin(3,10);
//---- indicator buffers mapping
   //SetIndexBuffer(0,ExtMapBuffer1);
   //SetIndexBuffer(1,ExtMapBuffer2);
   //SetIndexBuffer(2,ExtMapBuffer3);
   //SetIndexBuffer(3,ExtMapBuffer4);
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   double maOpen, maClose, maLow, maHigh;
   double haOpen, haHigh, haLow, haClose;
   if(Bars<=10) return(0);
   ExtCountedBars=IndicatorCounted();
//---- check for possible errors
   if (ExtCountedBars<0) return(-1);
//---- last counted bar will be recounted
   if (ExtCountedBars>0) ExtCountedBars--;
   int pos=Bars-ExtCountedBars-1;
   while(pos>=0)
     {
      maOpen=iMA(NULL,0,MaPeriod,0,MaMetod,MODE_OPEN,pos);
      maClose=iMA(NULL,0,MaPeriod,0,MaMetod,MODE_CLOSE,pos);
      maLow=iMA(NULL,0,MaPeriod,0,MaMetod,MODE_LOW,pos);
      maHigh=iMA(NULL,0,MaPeriod,0,MaMetod,MODE_HIGH,pos);

      haOpen=(ExtMapBuffer3[pos+1]+ExtMapBuffer4[pos+1])/2;
      haClose=(maOpen+maHigh+maLow+maClose)/4;
      haHigh=MathMax(maHigh, MathMax(haOpen, haClose));
      haLow=MathMin(maLow, MathMin(haOpen, haClose));
      if (haOpen<haClose) 
        {
trend[pos]=1;
         ExtMapBuffer1[pos]=0;
         ExtMapBuffer2[pos]=1;
         if (SoundAlertMode>0 && pos==0 && trend[1]<0) PlaySound("alert2.wav");
        } 
      else
        {
         trend[pos]=-1;
         ExtMapBuffer1[pos]=1;
         ExtMapBuffer2[pos]=0;
         if (SoundAlertMode>0 && pos==0 && trend[1]>0) PlaySound("alert2.wav");
        } 
      ExtMapBuffer3[pos]=haOpen;
      ExtMapBuffer4[pos]=haClose;
 	   pos--;
     }
//----------   
   string Message;
   
   if ( trend[2]<0 && trend[1]>0 && Volume[0]>1 && !UpTrendAlert)
	  {
	  Message = " "+Symbol()+" M"+Period()+": Signal for BUY";
	  if ( SoundAlertMode>0 ) Alert (Message); 
	  UpTrendAlert=true; DownTrendAlert=false;
	  } 
	 	  
	  if ( trend[2]>0 && trend[1]<0 && Volume[0]>1 && !DownTrendAlert)
	  {
	  Message = " "+Symbol()+" M"+Period()+": Signal for SELL";
	  if ( SoundAlertMode>0 ) Alert (Message); 
	  DownTrendAlert=true; UpTrendAlert=false;
	  } 	         
//----
   return(0);
  }
//+------------------------------------------